#include "UnitZealotInterface.h"
#include "Config.h"
#include "DrawManager.h"


void UnitZealotInterface::smartAttack(BWAPI::Unit u)
{
	if (u == NULL)
		return;

	// if we have issued a command to this unit already this frame, ignore this one
	if (BWAPI::Broodwar->getFrameCount() - unit->getLastCommandFrame() < Config::UnitZealotInterface::FrequencyFrame - 1)
	{
		return;
	}

	// get the unit's current command
	BWAPI::UnitCommand currentCommand(unit->getLastCommand());

	// same command
	if (currentCommand.getType() == BWAPI::UnitCommandTypes::Attack_Unit &&	currentCommand.getTarget() == u
		&& (BWAPI::Broodwar->getFrameCount() - unit->getLastCommandFrame() < 42))
	{
		return;
	}

	// if nothing prevents it, attack the target
	bool re = unit->attack(u);

	DrawManager::getInstance().drawAttack(unit, u, re);
}


void UnitZealotInterface::smartMove(BWAPI::Position p)
{
	// if we have issued a command to this unit already this frame, ignore this one
	if (unit->getLastCommand().getType() != BWAPI::UnitCommandTypes::None &&
		BWAPI::Broodwar->getFrameCount() - unit->getLastCommandFrame() < Config::UnitZealotInterface::FrequencyFrame - 1)
	{
		return;
	}

	// get the unit's current command
	BWAPI::UnitCommand currentCommand(unit->getLastCommand());

	// may be unit is stuck by something so that it does't move, so we shouldn't give too frequent command
	if ((currentCommand.getType() == BWAPI::UnitCommandTypes::Move)
		&& (currentCommand.getTargetPosition() == p)
		&& (BWAPI::Broodwar->getFrameCount() - unit->getLastCommandFrame() < 42))
	{
		return;
	}

	// if nothing prevents it, attack the target
	unit->move(p);

	DrawManager::getInstance().drawMove(unit, p);

}


void UnitZealotInterface::smartAttackMove(BWAPI::Position targetPosition)
{
	if(!targetPosition.isValid())
		return; 

	// if we have issued a command to this unit already this frame, ignore this one
	if (BWAPI::Broodwar->getFrameCount() - unit->getLastCommandFrame() < Config::UnitZealotInterface::FrequencyFrame - 1)
	{
		return;
	}

	// get the unit's current command
	BWAPI::UnitCommand currentCommand(unit->getLastCommand());

	// if we've recently already told this unit to attack this target, ignore
	if (currentCommand.getType() == BWAPI::UnitCommandTypes::Attack_Move &&	currentCommand.getTargetPosition() == targetPosition
		&& (BWAPI::Broodwar->getFrameCount() - unit->getLastCommandFrame() < 20))
	{
		return;
	}

	// if nothing prevents it, attack the target
	unit->attack(targetPosition);

}
